 -- Macro_Scripts File
 -- Purpose:  define action for each creatable MaxFluid objects to hook up to the create main menu (or quads)
 
 /*
 Revision History
 
     12 September 2017, Tom Hudson
     created for 3ds MAX 2018 Update 4
 */
 
 -- Macro Scripts for Fluids
 --***********************************************************************************************
 -- MODIFY THIS AT YOUR OWN RISK
 
 --------------------------------------------------------------------------------------------
 -- MaxFluids
 
 --------------------------------------------------------------------------------------------
 macroScript MaxLiquid 
             category:~FLUIDS_CATEGORY~ 
             internalCategory:"Fluids" 
             tooltip:~MAXLIQUID_TOOLTIP~ 
             ButtonText:~MAXLIQUID_BUTTONTEXT~
			 iconName:"MaxFluid/solveLiquidComponent"
(
     on execute do StartObjectCreation MaxLiquid
     on isChecked return (mcrUtils.IsCreating MaxLiquid)
)
 
 macroScript FluidLoader 
             category:~FLUIDS_CATEGORY~ 
             internalCategory:"Fluids" 
             tooltip:~FLUIDLOADER_TOOLTIP~ 
             ButtonText:~FLUIDLOADER_BUTTONTEXT~
			 iconName:"MaxFluid/FluidLoader"
(
     on execute do StartObjectCreation FluidLoader
     on isChecked return (mcrUtils.IsCreating FluidLoader)
)
 
macroScript SimulationView 
             category:~FLUIDS_CATEGORY~ 
             internalCategory:"Fluids" 
             tooltip:~SIMULATIONVIEW_TOOLTIP~ 
             ButtonText:~SIMULATIONVIEW_BUTTONTEXT~
 (
     on execute do FluidSimObjectManager.ShowInterface()
 )
 
macroScript ToggleSimulationView 
    category:~FLUIDS_CATEGORY~ 
    internalCategory:"Fluids" 
    tooltip:~TOGGLE_SIMULATIONVIEW_TOOLTIP~ 
    ButtonText:~TOGGLE_SIMULATIONVIEW_BUTTONTEXT~
	iconName:"MainUI/SimulationView"
(
	on isChecked return (FluidSimObjectManager.IsDialogOpen())
	on execute do 
	(
		if FluidSimObjectManager.IsDialogOpen() then
			FluidSimObjectManager.HideInterface()
		else
			FluidSimObjectManager.ShowInterface()
	)
 )
 

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBqyO3nVh7525Ugx64shaioHMz2fM66gIIj
-- 6SN8ALlIWtf1iFWg0WZ6Hw55+9xydvrS4Vzx5jDw8VUXlNgHWwujs2qgLvyJWHM1
-- L25/L1mKcP9IQSUD9yhXE9crRYOJDEPF8pdqRiqJelBdn4LbYrjAk9dAWDb9qCwV
-- JGnKADNWG9PisSE+Qb7TaqzIvMHs5dKKEOS5nreQmsQScCxMO/edl0/5EMcv4/bK
-- oMEdRCq1iybVxj0ly2SvP3doi6ZvA3GjdwYD5Zv3DWIHzA60xtnSMdUq4jY4OhTs
-- ydUOplAdEF8462TGAnkFpPyCHuLJOauGsPdNdmKWYSfyvLh7ogSv
-- -----END-SIGNATURE-----